var Zuck =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/zuck.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./src/zuck.js":
/*!*********************!*\
  !*** ./src/zuck.js ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("/*\n    zuck.js\n    https://github.com/ramon82/zuck.js\n    MIT License\n*/\nmodule.exports = function (window) {\n  /* Utilities */\n  var query = function query(qs) {\n    return document.querySelectorAll(qs)[0];\n  };\n\n  var get = function get(array, what) {\n    if (array) {\n      return array[what] || '';\n    } else {\n      return '';\n    }\n  };\n\n  var each = function each(arr, func) {\n    if (arr) {\n      var total = arr.length;\n\n      for (var i = 0; i < total; i++) {\n        func(i, arr[i]);\n      }\n    }\n  };\n\n  var setVendorVariable = function setVendorVariable(ref, variable, value) {\n    var variables = [variable.toLowerCase(), \"webkit\".concat(variable), \"MS\".concat(variable), \"o\".concat(variable)];\n    each(variables, function (i, val) {\n      ref[val] = value;\n    });\n  };\n\n  var addVendorEvents = function addVendorEvents(el, func, event) {\n    var events = [event.toLowerCase(), \"webkit\".concat(event), \"MS\".concat(event), \"o\".concat(event)];\n    each(events, function (i, val) {\n      el.addEventListener(val, func, false);\n    });\n  };\n\n  var onAnimationEnd = function onAnimationEnd(el, func) {\n    addVendorEvents(el, func, 'AnimationEnd');\n  };\n\n  var onTransitionEnd = function onTransitionEnd(el, func) {\n    if (!el.transitionEndEvent) {\n      el.transitionEndEvent = true;\n      addVendorEvents(el, func, 'TransitionEnd');\n    }\n  };\n\n  var prepend = function prepend(parent, child) {\n    if (parent.firstChild) {\n      parent.insertBefore(child, parent.firstChild);\n    } else {\n      parent.appendChild(child);\n    }\n  };\n\n  var generateId = function generateId() {\n    return 'stories-' + Math.random().toString(36).substr(2, 9);\n  };\n  /* Zuckera */\n\n\n  var ZuckJS = function ZuckJS(timeline, options) {\n    var zuck = this;\n\n    var option = function option(name, prop) {\n      var type = function type(what) {\n        return typeof what !== 'undefined';\n      };\n\n      if (prop) {\n        if (type(options[name])) {\n          return type(options[name][prop]) ? options[name][prop] : optionsDefault[name][prop];\n        } else {\n          return optionsDefault[name][prop];\n        }\n      } else {\n        return type(options[name]) ? options[name] : optionsDefault[name];\n      }\n    };\n\n    var fullScreen = function fullScreen(elem, cancel) {\n      var func = 'RequestFullScreen';\n      var elFunc = 'requestFullScreen'; // crappy vendor prefixes.\n\n      try {\n        if (cancel) {\n          if (document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement) {\n            if (document.exitFullscreen) {\n              document.exitFullscreen().catch(function () {});\n            } else if (document.mozCancelFullScreen) {\n              document.mozCancelFullScreen().catch(function () {});\n            } else if (document.mozCancelFullScreen) {\n              document.mozCancelFullScreen().catch(function () {});\n            }\n          }\n        } else {\n          if (elem[elFunc]) {\n            elem[elFunc]();\n          } else if (elem[\"ms\".concat(func)]) {\n            elem[\"ms\".concat(func)]();\n          } else if (elem[\"moz\".concat(func)]) {\n            elem[\"moz\".concat(func)]();\n          } else if (elem[\"webkit\".concat(func)]) {\n            elem[\"webkit\".concat(func)]();\n          }\n        }\n      } catch (e) {\n        console.warn('[Zuck.js] Can\\'t access fullscreen');\n      }\n    };\n\n    var translate = function translate(element, to, duration, ease) {\n      var direction = to > 0 ? 1 : -1;\n      var to3d = Math.abs(to) / query('#zuck-modal').offsetWidth * 90 * direction;\n\n      if (option('cubeEffect')) {\n        var scaling = to3d === 0 ? 'scale(0.95)' : 'scale(0.930,0.930)';\n        setVendorVariable(query('#zuck-modal-content').style, 'Transform', scaling);\n\n        if (to3d < -90 || to3d > 90) {\n          return false;\n        }\n      }\n\n      var transform = !option('cubeEffect') ? \"translate3d(\".concat(to, \"px, 0, 0)\") : \"rotateY(\".concat(to3d, \"deg)\");\n\n      if (element) {\n        setVendorVariable(element.style, 'TransitionTimingFunction', ease);\n        setVendorVariable(element.style, 'TransitionDuration', \"\".concat(duration, \"ms\"));\n        setVendorVariable(element.style, 'Transform', transform);\n      }\n    };\n\n    var findPos = function findPos(obj, offsetY, offsetX, stop) {\n      var curleft = 0;\n      var curtop = 0;\n\n      if (obj) {\n        if (obj.offsetParent) {\n          do {\n            curleft += obj.offsetLeft;\n            curtop += obj.offsetTop;\n\n            if (obj === stop) {\n              break;\n            }\n          } while (obj = obj.offsetParent);\n        }\n\n        if (offsetY) {\n          curtop = curtop - offsetY;\n        }\n\n        if (offsetX) {\n          curleft = curleft - offsetX;\n        }\n      }\n\n      return [curleft, curtop];\n    };\n\n    if (typeof timeline === 'string') {\n      timeline = document.getElementById(timeline);\n    }\n\n    if (!timeline.id) {\n      timeline.setAttribute('id', generateId());\n    }\n\n    var timeAgo = function timeAgo(time) {\n      time = Number(time) * 1000;\n      var dateObj = new Date(time);\n      var dateStr = dateObj.getTime();\n      var seconds = (new Date().getTime() - dateStr) / 1000;\n      var language = option('language', 'time');\n      var formats = [[60, \" \".concat(language.seconds), 1], // 60\n      [120, \"1 \".concat(language.minute), ''], // 60*2\n      [3600, \" \".concat(language.minutes), 60], // 60*60, 60\n      [7200, \"1 \".concat(language.hour), ''], // 60*60*2\n      [86400, \" \".concat(language.hours), 3600], // 60*60*24, 60*60\n      [172800, \" \".concat(language.yesterday), ''], // 60*60*24*2\n      [604800, \" \".concat(language.days), 86400]];\n      var currentFormat = 1;\n\n      if (seconds < 0) {\n        seconds = Math.abs(seconds);\n        currentFormat = 2;\n      }\n\n      var result = false;\n      each(formats, function (formatKey, format) {\n        if (seconds < format[0] && !result) {\n          if (typeof format[2] === 'string') {\n            result = format[currentFormat];\n          } else if (format !== null) {\n            result = Math.floor(seconds / format[2]) + format[1];\n          }\n        }\n      });\n\n      if (!result) {\n        var day = dateObj.getDate();\n        var month = dateObj.getMonth();\n        var year = dateObj.getFullYear();\n        return \"\".concat(day, \"/\").concat(month + 1, \"/\").concat(year);\n      } else {\n        return result;\n      }\n    };\n    /* options */\n\n\n    var id = timeline.id;\n    var optionsDefault = {\n      rtl: false,\n      skin: 'snapgram',\n      avatars: true,\n      stories: [],\n      backButton: true,\n      backNative: false,\n      paginationArrows: false,\n      previousTap: true,\n      autoFullScreen: false,\n      openEffect: true,\n      cubeEffect: false,\n      list: false,\n      localStorage: true,\n      callbacks: {\n        onOpen: function onOpen(storyId, callback) {\n          callback();\n        },\n        onView: function onView(storyId) {},\n        onEnd: function onEnd(storyId, callback) {\n          callback();\n        },\n        onClose: function onClose(storyId, callback) {\n          callback();\n        },\n        onNextItem: function onNextItem(storyId, nextStoryId, callback) {\n          callback();\n        },\n        onNavigateItem: function onNavigateItem(storyId, nextStoryId, callback) {\n          callback();\n        }\n      },\n      template: {\n        timelineItem: function timelineItem(itemData) {\n          return \"\\n            <div class=\\\"story \".concat(get(itemData, 'seen') === true ? 'seen' : '', \"\\\">\\n              <a class=\\\"item-link\\\" href=\\\"\").concat(get(itemData, 'link'), \"\\\">\\n                <span class=\\\"item-preview\\\">\\n                  <img lazy=\\\"eager\\\" src=\\\"\").concat(option('avatars') || !get(itemData, 'currentPreview') ? get(itemData, 'photo') : get(itemData, 'currentPreview'), \"\\\" />\\n                </span>\\n                <span class=\\\"info\\\" itemProp=\\\"author\\\" itemScope itemType=\\\"http://schema.org/Person\\\">\\n                  <strong class=\\\"name\\\" itemProp=\\\"name\\\">\").concat(get(itemData, 'name'), \"</strong>\\n                  <span class=\\\"time\\\">\").concat(get(itemData, 'lastUpdatedAgo'), \"</span>\\n                </span>\\n              </a>\\n              \\n              <ul class=\\\"items\\\"></ul>\\n            </div>\");\n        },\n        timelineStoryItem: function timelineStoryItem(itemData) {\n          var reserved = ['id', 'seen', 'src', 'link', 'linkText', 'time', 'type', 'length', 'preview'];\n          var attributes = \"\\n            href=\\\"\".concat(get(itemData, 'src'), \"\\\"\\n            data-link=\\\"\").concat(get(itemData, 'link'), \"\\\"\\n            data-linkText=\\\"\").concat(get(itemData, 'linkText'), \"\\\"\\n            data-time=\\\"\").concat(get(itemData, 'time'), \"\\\"\\n            data-type=\\\"\").concat(get(itemData, 'type'), \"\\\"\\n            data-length=\\\"\").concat(get(itemData, 'length'), \"\\\"\\n          \");\n\n          for (var dataKey in itemData) {\n            if (reserved.indexOf(dataKey) === -1) {\n              attributes += \" data-\".concat(dataKey, \"=\\\"\").concat(itemData[dataKey], \"\\\"\");\n            }\n          }\n\n          return \"<a \".concat(attributes, \">\\n                    <img loading=\\\"auto\\\" src=\\\"\").concat(get(itemData, 'preview'), \"\\\" />\\n                  </a>\");\n        },\n        viewerItem: function viewerItem(storyData, currentStoryItem) {\n          return \"<div class=\\\"story-viewer\\\">\\n                    <div class=\\\"head\\\">\\n                      <div class=\\\"left\\\">\\n                        \".concat(option('backButton') ? '<a class=\"back\">&lsaquo;</a>' : '', \"\\n\\n                        <span class=\\\"item-preview\\\">\\n                          <img lazy=\\\"eager\\\" class=\\\"profilePhoto\\\" src=\\\"\").concat(get(storyData, 'photo'), \"\\\" />\\n                        </span>\\n\\n                        <div class=\\\"info\\\">\\n                          <strong class=\\\"name\\\">\").concat(get(storyData, 'name'), \"</strong>\\n                          <span class=\\\"time\\\">\").concat(get(storyData, 'timeAgo'), \"</span>\\n                        </div>\\n                      </div>\\n\\n                      <div class=\\\"right\\\">\\n                        <span class=\\\"time\\\">\").concat(get(currentStoryItem, 'timeAgo'), \"</span>\\n                        <span class=\\\"loading\\\"></span>\\n                        <a class=\\\"close\\\" tabIndex=\\\"2\\\">&times;</a>\\n                      </div>\\n                    </div>\\n\\n                    <div class=\\\"slides-pointers\\\">\\n                      <div class=\\\"wrap\\\"></div>\\n                    </div>\\n\\n                    \").concat(option('paginationArrows') ? \"<div class=\\\"slides-pagination\\\">\\n                          <span class=\\\"previous\\\">&lsaquo;</span>\\n                          <span class=\\\"next\\\">&rsaquo;</span>\\n                        </div>\" : '', \"\\n                  </div>\");\n        },\n        viewerItemPointer: function viewerItemPointer(index, currentIndex, item) {\n          return \"<span \\n                    class=\\\"\".concat(currentIndex === index ? 'active' : '', \" \").concat(get(item, 'seen') === true ? 'seen' : '', \"\\\"\\n                    data-index=\\\"\").concat(index, \"\\\" data-item-id=\\\"\").concat(get(item, 'id'), \"\\\">\\n                      <b style=\\\"animation-duration:\").concat(get(item, 'length') === '' ? '3' : get(item, 'length'), \"s\\\"></b>\\n                  </span>\");\n        },\n        viewerItemBody: function viewerItemBody(index, currentIndex, item) {\n          return \"<div \\n                    class=\\\"item \".concat(get(item, 'seen') === true ? 'seen' : '', \" \").concat(currentIndex === index ? 'active' : '', \"\\\"\\n                    data-time=\\\"\").concat(get(item, 'time'), \"\\\" data-type=\\\"\").concat(get(item, 'type'), \"\\\" data-index=\\\"\").concat(index, \"\\\" data-item-id=\\\"\").concat(get(item, 'id'), \"\\\">\\n                    \").concat(get(item, 'type') === 'video' ? \"<video class=\\\"media\\\" muted webkit-playsinline playsinline preload=\\\"auto\\\" src=\\\"\".concat(get(item, 'src'), \"\\\" \").concat(get(item, 'type'), \"></video>\\n                        <b class=\\\"tip muted\\\">\").concat(option('language', 'unmute'), \"</b>\") : \"<img loading=\\\"auto\\\" class=\\\"media\\\" src=\\\"\".concat(get(item, 'src'), \"\\\" \").concat(get(item, 'type'), \" />\\n                    \"), \"\\n\\n                    \").concat(get(item, 'link') ? \"<a class=\\\"tip link\\\" href=\\\"\".concat(get(item, 'link'), \"\\\" rel=\\\"noopener\\\" target=\\\"_blank\\\">\\n                            \").concat(!get(item, 'linkText') || get(item, 'linkText') === '' ? option('language', 'visitLink') : get(item, 'linkText'), \"\\n                          </a>\") : '', \"\\n                  </div>\");\n        }\n      },\n      language: {\n        unmute: 'Touch to unmute',\n        keyboardTip: 'Press space to see next',\n        visitLink: 'Visit link',\n        time: {\n          ago: 'ago',\n          hour: 'hour ago',\n          hours: 'hours ago',\n          minute: 'minute ago',\n          minutes: 'minutes ago',\n          fromnow: 'from now',\n          seconds: 'seconds ago',\n          yesterday: 'yesterday',\n          tomorrow: 'tomorrow',\n          days: 'days ago'\n        }\n      }\n    };\n    /* modal */\n\n    var ZuckModal = function ZuckModal() {\n      var modalZuckContainer = query('#zuck-modal');\n\n      if (!modalZuckContainer && !zuck.hasModal) {\n        zuck.hasModal = true;\n        modalZuckContainer = document.createElement('div');\n        modalZuckContainer.id = 'zuck-modal';\n\n        if (option('cubeEffect')) {\n          modalZuckContainer.className = 'with-cube';\n        }\n\n        modalZuckContainer.innerHTML = '<div id=\"zuck-modal-content\"></div>';\n        modalZuckContainer.style.display = 'none';\n        modalZuckContainer.setAttribute('tabIndex', '1');\n\n        modalZuckContainer.onkeyup = function (_ref) {\n          var keyCode = _ref.keyCode;\n          var code = keyCode;\n\n          if (code === 27) {\n            modal.close();\n          } else if (code === 13 || code === 32) {\n            modal.next();\n          }\n        };\n\n        if (option('openEffect')) {\n          modalZuckContainer.classList.add('with-effects');\n        }\n\n        if (option('rtl')) {\n          modalZuckContainer.classList.add('rtl');\n        }\n\n        onTransitionEnd(modalZuckContainer, function () {\n          if (modalZuckContainer.classList.contains('closed')) {\n            modalContent.innerHTML = '';\n            modalZuckContainer.style.display = 'none';\n            modalZuckContainer.classList.remove('closed');\n            modalZuckContainer.classList.remove('animated');\n          }\n        });\n        document.body.appendChild(modalZuckContainer);\n      }\n\n      var modalContent = query('#zuck-modal-content');\n\n      var moveStoryItem = function moveStoryItem(direction) {\n        var modalContainer = query('#zuck-modal');\n        var target = '';\n        var useless = '';\n        var transform = 0;\n        var modalSlider = query(\"#zuck-modal-slider-\".concat(id));\n        var slideItems = {\n          previous: query('#zuck-modal .story-viewer.previous'),\n          next: query('#zuck-modal .story-viewer.next'),\n          viewing: query('#zuck-modal .story-viewer.viewing')\n        };\n\n        if (!slideItems.previous && !direction || !slideItems.next && direction) {\n          if (!option('rtl')) {\n            return false;\n          }\n        }\n\n        if (!direction) {\n          target = 'previous';\n          useless = 'next';\n        } else {\n          target = 'next';\n          useless = 'previous';\n        }\n\n        var transitionTime = 600;\n\n        if (option('cubeEffect')) {\n          if (target === 'previous') {\n            transform = modalContainer.slideWidth;\n          } else if (target === 'next') {\n            transform = modalContainer.slideWidth * -1;\n          }\n        } else {\n          transform = findPos(slideItems[target])[0] * -1;\n        }\n\n        translate(modalSlider, transform, transitionTime, null);\n        setTimeout(function () {\n          // set page data when transition complete\n          if (option('rtl')) {\n            var tmp = target;\n            target = useless;\n            useless = tmp;\n          }\n\n          if (target !== '' && slideItems[target] && useless !== '') {\n            var currentStory = slideItems[target].getAttribute('data-story-id');\n            zuck.internalData.currentStory = currentStory;\n            var oldStory = query(\"#zuck-modal .story-viewer.\".concat(useless));\n\n            if (oldStory) {\n              oldStory.parentNode.removeChild(oldStory);\n            }\n\n            if (slideItems.viewing) {\n              slideItems.viewing.classList.add('stopped');\n              slideItems.viewing.classList.add(useless);\n              slideItems.viewing.classList.remove('viewing');\n            }\n\n            if (slideItems[target]) {\n              slideItems[target].classList.remove('stopped');\n              slideItems[target].classList.remove(target);\n              slideItems[target].classList.add('viewing');\n            }\n\n            var newStoryData = getStoryMorningGlory(target);\n\n            if (newStoryData) {\n              createStoryViewer(newStoryData, target);\n            }\n\n            var storyId = zuck.internalData.currentStory;\n            var items = query(\"#zuck-modal [data-story-id=\\\"\".concat(storyId, \"\\\"]\"));\n\n            if (items) {\n              items = items.querySelectorAll('[data-index].active');\n              var duration = items[0].firstElementChild;\n              zuck.data[storyId].currentItem = parseInt(items[0].getAttribute('data-index'), 10);\n              items[0].innerHTML = \"<b style=\\\"\".concat(duration.style.cssText, \"\\\"></b>\");\n              onAnimationEnd(items[0].firstElementChild, function () {\n                zuck.nextItem(false);\n              });\n            }\n\n            translate(modalSlider, '0', 0, null);\n\n            if (items) {\n              var storyViewer = query(\"#zuck-modal .story-viewer[data-story-id=\\\"\".concat(currentStory, \"\\\"]\"));\n              playVideoItem(storyViewer, [items[0], items[1]], true);\n            }\n\n            option('callbacks', 'onView')(zuck.internalData.currentStory);\n          }\n        }, transitionTime + 50);\n      };\n\n      var createStoryViewer = function createStoryViewer(storyData, className, forcePlay) {\n        var modalSlider = query(\"#zuck-modal-slider-\".concat(id));\n        var storyItems = get(storyData, 'items');\n        storyData.timeAgo = storyItems && storyItems[0] ? timeAgo(get(storyItems[0], 'time')) : '';\n        var htmlItems = '';\n        var pointerItems = '';\n        var storyId = get(storyData, 'id');\n        var slides = document.createElement('div');\n        var currentItem = get(storyData, 'currentItem') || 0;\n        var exists = query(\"#zuck-modal .story-viewer[data-story-id=\\\"\".concat(storyId, \"\\\"]\"));\n\n        if (exists) {\n          return false;\n        }\n\n        slides.className = 'slides';\n        each(storyItems, function (i, item) {\n          item.timeAgo = timeAgo(get(item, 'time'));\n\n          if (currentItem > i) {\n            storyData.items[i].timeAgo = item.timeAgo;\n            storyData.items[i].seen = true;\n            item.seen = true;\n          }\n\n          pointerItems += option('template', 'viewerItemPointer')(i, currentItem, item);\n          htmlItems += option('template', 'viewerItemBody')(i, currentItem, item);\n        });\n        slides.innerHTML = htmlItems;\n        var video = slides.querySelector('video');\n\n        var addMuted = function addMuted(video) {\n          if (video.muted) {\n            storyViewer.classList.add('muted');\n          } else {\n            storyViewer.classList.remove('muted');\n          }\n        };\n\n        if (video) {\n          video.onwaiting = function (e) {\n            if (video.paused) {\n              storyViewer.classList.add('paused');\n              storyViewer.classList.add('loading');\n            }\n          };\n\n          video.onplay = function () {\n            addMuted(video);\n            storyViewer.classList.remove('stopped');\n            storyViewer.classList.remove('paused');\n            storyViewer.classList.remove('loading');\n          };\n\n          video.onload = video.onplaying = video.oncanplay = function () {\n            addMuted(video);\n            storyViewer.classList.remove('loading');\n          };\n\n          video.onvolumechange = function () {\n            addMuted(video);\n          };\n        }\n\n        var storyViewerWrap = document.createElement('div');\n        storyViewerWrap.innerHTML = option('template', 'viewerItem')(storyData, currentItem);\n        var storyViewer = storyViewerWrap.firstElementChild;\n        storyViewer.className = \"story-viewer muted \".concat(className, \" \").concat(!forcePlay ? 'stopped' : '', \" \").concat(option('backButton') ? 'with-back-button' : '');\n        storyViewer.setAttribute('data-story-id', storyId);\n        storyViewer.querySelector('.slides-pointers .wrap').innerHTML = pointerItems;\n        each(storyViewer.querySelectorAll('.close, .back'), function (i, el) {\n          el.onclick = function (e) {\n            e.preventDefault();\n            modal.close();\n          };\n        });\n        storyViewer.appendChild(slides);\n\n        if (className === 'viewing') {\n          playVideoItem(storyViewer, storyViewer.querySelectorAll(\"[data-index=\\\"\".concat(currentItem, \"\\\"].active\")), false);\n        }\n\n        each(storyViewer.querySelectorAll('.slides-pointers [data-index] > b'), function (i, el) {\n          onAnimationEnd(el, function () {\n            zuck.nextItem(false);\n          });\n        });\n\n        if (className === 'previous') {\n          prepend(modalSlider, storyViewer);\n        } else {\n          modalSlider.appendChild(storyViewer);\n        }\n      };\n\n      var createStoryTouchEvents = function createStoryTouchEvents(modalSliderElement) {\n        var modalContainer = query('#zuck-modal');\n        var enableMouseEvents = true;\n        var modalSlider = modalSliderElement;\n        var position = {};\n        var touchOffset = null;\n        var isScrolling = null;\n        var delta = null;\n        var timer = null;\n        var nextTimer = null;\n\n        var touchStart = function touchStart(event) {\n          var storyViewer = query('#zuck-modal .viewing');\n\n          if (event.target.nodeName === 'A') {\n            return;\n          }\n\n          var touches = event.touches ? event.touches[0] : event;\n          var pos = findPos(query('#zuck-modal .story-viewer.viewing'));\n          modalContainer.slideWidth = query('#zuck-modal .story-viewer').offsetWidth;\n          modalContainer.slideHeight = query('#zuck-modal .story-viewer').offsetHeight;\n          position = {\n            x: pos[0],\n            y: pos[1]\n          };\n          var clientX = touches.clientX;\n          var clientY = touches.clientY;\n          touchOffset = {\n            x: clientX,\n            y: clientY,\n            time: Date.now(),\n            valid: true\n          };\n\n          if (clientY < 80 || clientY > modalContainer.slideHeight - 80) {\n            touchOffset.valid = false;\n          } else {\n            event.preventDefault();\n            isScrolling = undefined;\n            delta = {};\n\n            if (enableMouseEvents) {\n              modalSlider.addEventListener('mousemove', touchMove);\n              modalSlider.addEventListener('mouseup', touchEnd);\n              modalSlider.addEventListener('mouseleave', touchEnd);\n            }\n\n            modalSlider.addEventListener('touchmove', touchMove);\n            modalSlider.addEventListener('touchend', touchEnd);\n\n            if (storyViewer) {\n              storyViewer.classList.add('paused');\n            }\n\n            pauseVideoItem();\n            timer = setTimeout(function () {\n              storyViewer.classList.add('longPress');\n            }, 600);\n            nextTimer = setTimeout(function () {\n              clearInterval(nextTimer);\n              nextTimer = false;\n            }, 250);\n          }\n        };\n\n        var touchMove = function touchMove(event) {\n          var touches = event.touches ? event.touches[0] : event;\n          var clientX = touches.clientX;\n          var clientY = touches.clientY;\n\n          if (touchOffset && touchOffset.valid) {\n            delta = {\n              x: clientX - touchOffset.x,\n              y: clientY - touchOffset.y\n            };\n\n            if (typeof isScrolling === 'undefined') {\n              isScrolling = !!(isScrolling || Math.abs(delta.x) < Math.abs(delta.y));\n            }\n\n            if (!isScrolling && touchOffset) {\n              event.preventDefault();\n              translate(modalSlider, position.x + delta.x, 0, null);\n            }\n          }\n        };\n\n        var touchEnd = function touchEnd(event) {\n          var storyViewer = query('#zuck-modal .viewing');\n          var lastTouchOffset = touchOffset;\n          var duration = touchOffset ? Date.now() - touchOffset.time : undefined;\n          var isValid = Number(duration) < 300 && Math.abs(delta.x) > 25 || Math.abs(delta.x) > modalContainer.slideWidth / 3;\n          var direction = delta.x < 0;\n          var index = direction ? query('#zuck-modal .story-viewer.next') : query('#zuck-modal .story-viewer.previous');\n          var isOutOfBounds = direction && !index || !direction && !index;\n\n          if (touchOffset && !touchOffset.valid) {} else {\n            if (delta) {\n              if (!isScrolling) {\n                if (isValid && !isOutOfBounds) {\n                  moveStoryItem(direction);\n                } else {\n                  translate(modalSlider, position.x, 300);\n                }\n              }\n\n              touchOffset = undefined;\n\n              if (enableMouseEvents) {\n                modalSlider.removeEventListener('mousemove', touchMove);\n                modalSlider.removeEventListener('mouseup', touchEnd);\n                modalSlider.removeEventListener('mouseleave', touchEnd);\n              }\n\n              modalSlider.removeEventListener('touchmove', touchMove);\n              modalSlider.removeEventListener('touchend', touchEnd);\n            }\n\n            var video = zuck.internalData.currentVideoElement;\n\n            if (timer) {\n              clearInterval(timer);\n            }\n\n            if (storyViewer) {\n              playVideoItem(storyViewer, storyViewer.querySelectorAll('.active'), false);\n              storyViewer.classList.remove('longPress');\n              storyViewer.classList.remove('paused');\n            }\n\n            if (nextTimer) {\n              clearInterval(nextTimer);\n              nextTimer = false;\n\n              var navigateItem = function navigateItem() {\n                if (!direction) {\n                  if (lastTouchOffset.x > window.screen.availWidth / 3 || !option('previousTap')) {\n                    if (option('rtl')) {\n                      zuck.navigateItem('previous', event);\n                    } else {\n                      zuck.navigateItem('next', event);\n                    }\n                  } else {\n                    if (option('rtl')) {\n                      zuck.navigateItem('next', event);\n                    } else {\n                      zuck.navigateItem('previous', event);\n                    }\n                  }\n                }\n              };\n\n              var storyViewerViewing = query('#zuck-modal .viewing');\n\n              if (storyViewerViewing && video) {\n                if (storyViewerViewing.classList.contains('muted')) {\n                  unmuteVideoItem(video, storyViewerViewing);\n                } else {\n                  navigateItem();\n                }\n              } else {\n                navigateItem();\n                return false;\n              }\n            }\n          }\n        };\n\n        modalSlider.addEventListener('touchstart', touchStart);\n\n        if (enableMouseEvents) {\n          modalSlider.addEventListener('mousedown', touchStart);\n        }\n      };\n\n      return {\n        show: function show(storyId, page) {\n          var modalContainer = query('#zuck-modal');\n\n          var callback = function callback() {\n            modalContent.innerHTML = \"<div id=\\\"zuck-modal-slider-\".concat(id, \"\\\" class=\\\"slider\\\"></div>\");\n            var storyData = zuck.data[storyId];\n            var currentItem = storyData.currentItem || 0;\n            var modalSlider = query(\"#zuck-modal-slider-\".concat(id));\n            createStoryTouchEvents(modalSlider);\n            zuck.internalData.currentStory = storyId;\n            storyData.currentItem = currentItem;\n\n            if (option('backNative')) {\n              window.location.hash = \"#!\".concat(id);\n            }\n\n            var previousItemData = getStoryMorningGlory('previous');\n\n            if (previousItemData) {\n              createStoryViewer(previousItemData, 'previous');\n            }\n\n            createStoryViewer(storyData, 'viewing', true);\n            var nextItemData = getStoryMorningGlory('next');\n\n            if (nextItemData) {\n              createStoryViewer(nextItemData, 'next');\n            }\n\n            if (option('autoFullScreen')) {\n              modalContainer.classList.add('fullscreen');\n            }\n\n            var tryFullScreen = function tryFullScreen() {\n              if (modalContainer.classList.contains('fullscreen') && option('autoFullScreen') && window.screen.availWidth <= 1024) {\n                fullScreen(modalContainer);\n              }\n\n              modalContainer.focus();\n            };\n\n            if (option('openEffect')) {\n              var storyEl = query(\"#\".concat(id, \" [data-id=\\\"\").concat(storyId, \"\\\"] .item-preview\"));\n              var pos = findPos(storyEl);\n              modalContainer.style.marginLeft = \"\".concat(pos[0] + storyEl.offsetWidth / 2, \"px\");\n              modalContainer.style.marginTop = \"\".concat(pos[1] + storyEl.offsetHeight / 2, \"px\");\n              modalContainer.style.display = 'block';\n              modalContainer.slideWidth = query('#zuck-modal .story-viewer').offsetWidth;\n              setTimeout(function () {\n                modalContainer.classList.add('animated');\n              }, 10);\n              setTimeout(function () {\n                tryFullScreen();\n              }, 300); // because effects\n            } else {\n              modalContainer.style.display = 'block';\n              modalContainer.slideWidth = query('#zuck-modal .story-viewer').offsetWidth;\n              tryFullScreen();\n            }\n\n            option('callbacks', 'onView')(storyId);\n          };\n\n          option('callbacks', 'onOpen')(storyId, callback);\n        },\n        next: function next(unmute) {\n          var callback = function callback() {\n            var lastStory = zuck.internalData.currentStory;\n            var lastStoryTimelineElement = query(\"#\".concat(id, \" [data-id=\\\"\").concat(lastStory, \"\\\"]\"));\n\n            if (lastStoryTimelineElement) {\n              lastStoryTimelineElement.classList.add('seen');\n              zuck.data[lastStory].seen = true;\n              zuck.internalData.seenItems[lastStory] = true;\n              saveLocalData('seenItems', zuck.internalData.seenItems);\n              updateStorySeenPosition();\n            }\n\n            var stories = query('#zuck-modal .story-viewer.next');\n\n            if (!stories) {\n              modal.close();\n            } else {\n              if (option('rtl')) {\n                moveStoryItem(false);\n              } else {\n                moveStoryItem(true);\n              }\n            }\n          };\n\n          option('callbacks', 'onEnd')(zuck.internalData.currentStory, callback);\n        },\n        close: function close() {\n          var modalContainer = query('#zuck-modal');\n\n          var callback = function callback() {\n            if (option('backNative')) {\n              window.location.hash = '';\n            }\n\n            fullScreen(modalContainer, true);\n\n            if (option('openEffect')) {\n              modalContainer.classList.add('closed');\n            } else {\n              modalContent.innerHTML = '';\n              modalContainer.style.display = 'none';\n            }\n          };\n\n          option('callbacks', 'onClose')(zuck.internalData.currentStory, callback);\n        }\n      };\n    };\n\n    var modal = ZuckModal();\n    /* parse functions */\n\n    var parseItems = function parseItems(story, forceUpdate) {\n      var storyId = story.getAttribute('data-id');\n      var storyItems = document.querySelectorAll(\"#\".concat(id, \" [data-id=\\\"\").concat(storyId, \"\\\"] .items > li\"));\n      var items = [];\n\n      if (!option('reactive') || forceUpdate) {\n        each(storyItems, function (i, _ref2) {\n          var firstElementChild = _ref2.firstElementChild;\n          var a = firstElementChild;\n          var img = a.firstElementChild;\n          var item = {\n            id: a.getAttribute('data-id'),\n            src: a.getAttribute('href'),\n            length: a.getAttribute('data-length'),\n            type: a.getAttribute('data-type'),\n            time: a.getAttribute('data-time'),\n            link: a.getAttribute('data-link'),\n            linkText: a.getAttribute('data-linkText'),\n            preview: img.getAttribute('src')\n          }; // collect all attributes\n\n          var all = a.attributes; // exclude the reserved options\n\n          var reserved = ['data-id', 'href', 'data-length', 'data-type', 'data-time', 'data-link', 'data-linktext'];\n\n          for (var z = 0; z < all.length; z++) {\n            if (reserved.indexOf(all[z].nodeName) === -1) {\n              item[all[z].nodeName.replace('data-', '')] = all[z].nodeValue;\n            }\n          } // destruct the remaining attributes as options\n\n\n          items.push(item);\n        });\n        zuck.data[storyId].items = items;\n        var callback = option('callbacks', 'onDataUpdate');\n\n        if (callback) {\n          callback(zuck.data, function () {});\n        }\n      }\n    };\n\n    var parseStory = function parseStory(story, returnCallback) {\n      var storyId = story.getAttribute('data-id');\n      var seen = false;\n\n      if (zuck.internalData.seenItems[storyId]) {\n        seen = true;\n      }\n      /*\n      REACT\n      if (seen) {\n        story.classList.add('seen');\n      } else {\n        story.classList.remove('seen');\n      }\n      */\n\n\n      try {\n        if (!zuck.data[storyId]) {\n          zuck.data[storyId] = {};\n        }\n\n        zuck.data[storyId].id = storyId; // story id\n\n        zuck.data[storyId].photo = story.getAttribute('data-photo'); // story preview (or user photo)\n\n        zuck.data[storyId].name = story.querySelector('.name').innerText;\n        zuck.data[storyId].link = story.querySelector('.item-link').getAttribute('href');\n        zuck.data[storyId].lastUpdated = story.getAttribute('data-last-updated');\n        zuck.data[storyId].seen = seen;\n\n        if (!zuck.data[storyId].items) {\n          zuck.data[storyId].items = [];\n          zuck.data[storyId].noItems = true;\n        }\n      } catch (e) {\n        zuck.data[storyId] = {\n          items: []\n        };\n      }\n\n      story.onclick = function (e) {\n        e.preventDefault();\n        modal.show(storyId);\n      };\n\n      var callback = option('callbacks', 'onDataUpdate');\n\n      if (callback) {\n        callback(zuck.data, function () {});\n      }\n    }; // BIBLICAL\n\n\n    var getStoryMorningGlory = function getStoryMorningGlory(what) {\n      // my wife told me to stop singing Wonderwall. I SAID MAYBE.\n      var currentStory = zuck.internalData.currentStory;\n      var whatElementYouMean = \"\".concat(what, \"ElementSibling\");\n\n      if (currentStory) {\n        var foundStory = query(\"#\".concat(id, \" [data-id=\\\"\").concat(currentStory, \"\\\"]\"))[whatElementYouMean];\n\n        if (foundStory) {\n          var storyId = foundStory.getAttribute('data-id');\n          var data = zuck.data[storyId] || false;\n          return data;\n        }\n      }\n\n      return false;\n    };\n\n    var updateStorySeenPosition = function updateStorySeenPosition() {\n      each(document.querySelectorAll(\"#\".concat(id, \" .story.seen\")), function (i, el) {\n        var newData = zuck.data[el.getAttribute('data-id')];\n        var timeline = el.parentNode;\n\n        if (!option('reactive')) {\n          timeline.removeChild(el);\n        }\n\n        zuck.update(newData, true);\n      });\n    };\n\n    var playVideoItem = function playVideoItem(storyViewer, elements, unmute) {\n      var itemElement = elements[1];\n      var itemPointer = elements[0];\n\n      if (!itemElement || !itemPointer) {\n        return false;\n      }\n\n      var cur = zuck.internalData.currentVideoElement;\n\n      if (cur) {\n        cur.pause();\n      }\n\n      if (itemElement.getAttribute('data-type') === 'video') {\n        var video = itemElement.getElementsByTagName('video')[0];\n\n        if (!video) {\n          zuck.internalData.currentVideoElement = false;\n          return false;\n        }\n\n        var setDuration = function setDuration() {\n          if (video.duration) {\n            setVendorVariable(itemPointer.getElementsByTagName('b')[0].style, 'AnimationDuration', \"\".concat(video.duration, \"s\"));\n          }\n        };\n\n        setDuration();\n        video.addEventListener('loadedmetadata', setDuration);\n        zuck.internalData.currentVideoElement = video;\n        video.play();\n\n        if (unmute && unmute.target) {\n          unmuteVideoItem(video, storyViewer);\n        }\n      } else {\n        zuck.internalData.currentVideoElement = false;\n      }\n    };\n\n    var pauseVideoItem = function pauseVideoItem() {\n      var video = zuck.internalData.currentVideoElement;\n\n      if (video) {\n        try {\n          video.pause();\n        } catch (e) {}\n      }\n    };\n\n    var unmuteVideoItem = function unmuteVideoItem(video, storyViewer) {\n      video.muted = false;\n      video.volume = 1.0;\n      video.removeAttribute('muted');\n      video.play();\n\n      if (video.paused) {\n        video.muted = true;\n        video.play();\n      }\n\n      if (storyViewer) {\n        storyViewer.classList.remove('paused');\n      }\n    };\n    /* data functions */\n\n\n    var saveLocalData = function saveLocalData(key, data) {\n      try {\n        if (option('localStorage')) {\n          var keyName = \"zuck-\".concat(id, \"-\").concat(key);\n          window.localStorage[keyName] = JSON.stringify(data);\n        }\n      } catch (e) {}\n    };\n\n    var getLocalData = function getLocalData(key) {\n      if (option('localStorage')) {\n        var keyName = \"zuck-\".concat(id, \"-\").concat(key);\n        return window.localStorage[keyName] ? JSON.parse(window.localStorage[keyName]) : false;\n      } else {\n        return false;\n      }\n    };\n    /* api */\n\n\n    zuck.data = option('stories') || {};\n    zuck.internalData = {};\n    zuck.internalData.seenItems = getLocalData('seenItems') || {};\n\n    zuck.add = zuck.update = function (data, append) {\n      var storyId = get(data, 'id');\n      var storyEl = query(\"#\".concat(id, \" [data-id=\\\"\").concat(storyId, \"\\\"]\"));\n      var items = get(data, 'items');\n      var story;\n      var preview = false;\n\n      if (items[0]) {\n        preview = items[0].preview || '';\n      }\n\n      if (zuck.internalData.seenItems[storyId] === true) {\n        data.seen = true;\n      }\n\n      data.currentPreview = preview;\n\n      if (!storyEl) {\n        var storyItem = document.createElement('div');\n        storyItem.innerHTML = option('template', 'timelineItem')(data);\n        story = storyItem.firstElementChild;\n      } else {\n        story = storyEl;\n      }\n\n      if (data.seen === false) {\n        zuck.internalData.seenItems[storyId] = false;\n        saveLocalData('seenItems', zuck.internalData.seenItems);\n      }\n\n      story.setAttribute('data-id', storyId);\n      story.setAttribute('data-photo', get(data, 'photo'));\n      story.setAttribute('data-last-updated', get(data, 'lastUpdated'));\n      parseStory(story);\n\n      if (!storyEl && !option('reactive')) {\n        if (append) {\n          timeline.appendChild(story);\n        } else {\n          prepend(timeline, story);\n        }\n      }\n\n      each(items, function (i, item) {\n        zuck.addItem(storyId, item, append);\n      });\n\n      if (!append) {\n        updateStorySeenPosition();\n      }\n    };\n\n    zuck.next = function () {\n      modal.next();\n    };\n\n    zuck.remove = function (storyId) {\n      var story = query(\"#\".concat(id, \" > [data-id=\\\"\").concat(storyId, \"\\\"]\"));\n      story.parentNode.removeChild(story);\n    };\n\n    zuck.addItem = function (storyId, data, append) {\n      var story = query(\"#\".concat(id, \" > [data-id=\\\"\").concat(storyId, \"\\\"]\"));\n\n      if (!option('reactive')) {\n        var li = document.createElement('li');\n        var el = story.querySelectorAll('.items')[0];\n        li.className = get(data, 'seen') ? 'seen' : '';\n        li.setAttribute('data-id', get(data, 'id')); // wow, too much jsx\n\n        li.innerHTML = option('template', 'timelineStoryItem')(data);\n\n        if (append) {\n          el.appendChild(li);\n        } else {\n          prepend(el, li);\n        }\n      }\n\n      parseItems(story);\n    };\n\n    zuck.removeItem = function (storyId, itemId) {\n      var item = query(\"#\".concat(id, \" > [data-id=\\\"\").concat(storyId, \"\\\"] [data-id=\\\"\").concat(itemId, \"\\\"]\"));\n\n      if (!option('reactive')) {\n        timeline.parentNode.removeChild(item);\n      }\n    };\n\n    zuck.navigateItem = zuck.nextItem = function (direction, event) {\n      var currentStory = zuck.internalData.currentStory;\n      var currentItem = zuck.data[currentStory].currentItem;\n      var storyViewer = query(\"#zuck-modal .story-viewer[data-story-id=\\\"\".concat(currentStory, \"\\\"]\"));\n      var directionNumber = direction === 'previous' ? -1 : 1;\n\n      if (!storyViewer || storyViewer.touchMove === 1) {\n        return false;\n      }\n\n      var currentItemElements = storyViewer.querySelectorAll(\"[data-index=\\\"\".concat(currentItem, \"\\\"]\"));\n      var currentPointer = currentItemElements[0];\n      var currentItemElement = currentItemElements[1];\n      var navigateItem = currentItem + directionNumber;\n      var nextItems = storyViewer.querySelectorAll(\"[data-index=\\\"\".concat(navigateItem, \"\\\"]\"));\n      var nextPointer = nextItems[0];\n      var nextItem = nextItems[1];\n\n      if (storyViewer && nextPointer && nextItem) {\n        var navigateItemCallback = function navigateItemCallback() {\n          if (direction === 'previous') {\n            currentPointer.classList.remove('seen');\n            currentItemElement.classList.remove('seen');\n          } else {\n            currentPointer.classList.add('seen');\n            currentItemElement.classList.add('seen');\n          }\n\n          currentPointer.classList.remove('active');\n          currentItemElement.classList.remove('active');\n          nextPointer.classList.remove('seen');\n          nextPointer.classList.add('active');\n          nextItem.classList.remove('seen');\n          nextItem.classList.add('active');\n          each(storyViewer.querySelectorAll('.time'), function (i, el) {\n            el.innerText = timeAgo(nextItem.getAttribute('data-time'));\n          });\n          zuck.data[currentStory].currentItem = zuck.data[currentStory].currentItem + directionNumber;\n          playVideoItem(storyViewer, nextItems, event);\n        };\n\n        var callback = option('callbacks', 'onNavigateItem');\n        callback = !callback ? option('callbacks', 'onNextItem') : option('callbacks', 'onNavigateItem');\n        callback(currentStory, nextItem.getAttribute('data-story-id'), navigateItemCallback);\n      } else if (storyViewer) {\n        if (direction !== 'previous') {\n          modal.next(event);\n        }\n      }\n    };\n\n    var init = function init() {\n      if (timeline && timeline.querySelector('.story')) {\n        each(timeline.querySelectorAll('.story'), function (storyIndex, story) {\n          parseStory(story);\n        });\n      }\n\n      if (option('backNative')) {\n        if (window.location.hash === \"#!\".concat(id)) {\n          window.location.hash = '';\n        }\n\n        window.addEventListener('popstate', function (e) {\n          if (window.location.hash !== \"#!\".concat(id)) {\n            window.location.hash = '';\n          }\n        }, false);\n      }\n\n      if (!option('reactive')) {\n        var seenItems = getLocalData('seenItems');\n        each(Object.keys(seenItems), function (keyIndex, key) {\n          if (zuck.data[key]) {\n            zuck.data[key].seen = seenItems[key];\n          }\n        });\n      }\n\n      each(option('stories'), function (itemKey, item) {\n        zuck.add(item, true);\n      });\n      updateStorySeenPosition();\n      var avatars = option('avatars') ? 'user-icon' : 'story-preview';\n      var list = option('list') ? 'list' : 'carousel';\n      var rtl = option('rtl') ? 'rtl' : '';\n      timeline.className += \" stories \".concat(avatars, \" \").concat(list, \" \").concat(\"\".concat(option('skin')).toLowerCase(), \" \").concat(rtl);\n      return zuck;\n    };\n\n    return init();\n  };\n  /* Helpers */\n\n\n  ZuckJS.buildTimelineItem = function (id, photo, name, link, lastUpdated, items) {\n    var timelineItem = {\n      id: id,\n      photo: photo,\n      name: name,\n      link: link,\n      lastUpdated: lastUpdated,\n      items: []\n    };\n    each(items, function (itemIndex, itemArgs) {\n      timelineItem.items.push(ZuckJS.buildStoryItem.apply(ZuckJS, itemArgs));\n    });\n    return timelineItem;\n  };\n\n  ZuckJS.buildStoryItem = function (id, type, length, src, preview, link, linkText, seen, time) {\n    return {\n      id: id,\n      type: type,\n      length: length,\n      src: src,\n      preview: preview,\n      link: link,\n      linkText: linkText,\n      seen: seen,\n      time: time\n    };\n  };\n  /* Legacy code */\n\n\n  ZuckJS.buildItem = ZuckJS.buildStoryItem; // CommonJS and Node.js module support.\n\n  if (true) {\n    // Support Node.js specific `module.exports` (which can be a function)\n    if ( true && module.exports) {\n      exports = module.exports = ZuckJS;\n    } // But always support CommonJS module 1.1.1 spec (`exports` cannot be a function)\n\n\n    exports.ZuckJS = ZuckJS;\n  } else {}\n\n  return ZuckJS;\n}(window || {});\n\n//# sourceURL=webpack://Zuck/./src/zuck.js?");

/***/ })

/******/ });