/*!
 * jQuery Mobile Events
 * by Ben Major
 *
 * Copyright 2011-2019, Ben Major
 * Licensed under the MIT License:
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 */
"use strict";!function(e){e.attrFn=e.attrFn||{};var t="ontouchstart"in window,a={tap_pixel_range:5,swipe_h_threshold:50,swipe_v_threshold:50,taphold_threshold:750,doubletap_int:500,shake_threshold:15,touch_capable:t,orientation_support:"orientation"in window&&"onorientationchange"in window,startevent:t?"touchstart":"mousedown",endevent:t?"touchend":"mouseup",moveevent:t?"touchmove":"mousemove",tapevent:t?"tap":"click",scrollevent:t?"touchmove":"scroll",hold_timer:null,tap_timer:null};e.touch={},e.isTouchCapable=function(){return a.touch_capable},e.getStartEvent=function(){return a.startevent},e.getEndEvent=function(){return a.endevent},e.getMoveEvent=function(){return a.moveevent},e.getTapEvent=function(){return a.tapevent},e.getScrollEvent=function(){return a.scrollevent},e.touch.setSwipeThresholdX=function(e){if("number"!=typeof e)throw new Error("Threshold parameter must be a type of number");a.swipe_h_threshold=e},e.touch.setSwipeThresholdY=function(e){if("number"!=typeof e)throw new Error("Threshold parameter must be a type of number");a.swipe_v_threshold=e},e.touch.setDoubleTapInt=function(e){if("number"!=typeof e)throw new Error("Interval parameter must be a type of number");a.doubletap_int=e},e.touch.setTapHoldThreshold=function(e){if("number"!=typeof e)throw new Error("Threshold parameter must be a type of number");a.taphold_threshold=e},e.touch.setTapRange=function(e){if("number"!=typeof e)throw new Error("Ranger parameter must be a type of number");a.tap_pixel_range=threshold},e.each(["tapstart","tapend","tapmove","tap","singletap","doubletap","taphold","swipe","swipeup","swiperight","swipedown","swipeleft","swipeend","scrollstart","scrollend","orientationchange","tap2","taphold2"],function(t,a){e.fn[a]=function(e){return e?this.on(a,e):this.trigger(a)},e.attrFn[a]=!0}),e.event.special.tapstart={setup:function(){var t=this,o=e(t);o.on(a.startevent,function e(n){if(o.data("callee",e),n.which&&1!==n.which)return!1;var i=o.get(0)!==window&&o.get(0)!==document?o.offset():{left:0,top:0},r=n.originalEvent,p={position:{x:a.touch_capable?r.touches[0].pageX:n.pageX,y:a.touch_capable?r.touches[0].pageY:n.pageY},offset:{x:a.touch_capable?Math.round(r.changedTouches[0].pageX-i.left):Math.round(n.pageX-i.left),y:a.touch_capable?Math.round(r.changedTouches[0].pageY-i.top):Math.round(n.pageY-i.top)},time:Date.now(),target:n.target};return w(t,"tapstart",n,p),!0})},remove:function(){e(this).off(a.startevent,e(this).data.callee)}},e.event.special.tapmove={setup:function(){var t=this,o=e(t);o.on(a.moveevent,function e(n){o.data("callee",e);var i=o.get(0)!==window&&o.get(0)!==document?o.offset():{left:0,top:0},r=n.originalEvent,p={position:{x:a.touch_capable?r.touches[0].pageX:n.pageX,y:a.touch_capable?r.touches[0].pageY:n.pageY},offset:{x:a.touch_capable?Math.round(r.changedTouches[0].pageX-i.left):Math.round(n.pageX-i.left),y:a.touch_capable?Math.round(r.changedTouches[0].pageY-i.top):Math.round(n.pageY-i.top)},time:Date.now(),target:n.target};return w(t,"tapmove",n,p),!0})},remove:function(){e(this).off(a.moveevent,e(this).data.callee)}},e.event.special.tapend={setup:function(){var t=this,o=e(t);o.on(a.endevent,function e(n){o.data("callee",e);var i=o.get(0)!==window&&o.get(0)!==document?o.offset():{left:0,top:0},r=n.originalEvent,p={position:{x:a.touch_capable?r.changedTouches[0].pageX:n.pageX,y:a.touch_capable?r.changedTouches[0].pageY:n.pageY},offset:{x:a.touch_capable?Math.round(r.changedTouches[0].pageX-i.left):Math.round(n.pageX-i.left),y:a.touch_capable?Math.round(r.changedTouches[0].pageY-i.top):Math.round(n.pageY-i.top)},time:Date.now(),target:n.target};return w(t,"tapend",n,p),!0})},remove:function(){e(this).off(a.endevent,e(this).data.callee)}},e.event.special.taphold={setup:function(){var t,o=this,n=e(o),i={x:0,y:0},r=0,p=0;n.on(a.startevent,function e(h){if(h.which&&1!==h.which)return!1;n.data("tapheld",!1),t=h.target;var c=h.originalEvent,s=Date.now();a.touch_capable?c.touches[0].pageX:h.pageX,a.touch_capable?c.touches[0].pageY:h.pageY,a.touch_capable?(c.touches[0].pageX,c.touches[0].target.offsetLeft):h.offsetX,a.touch_capable?(c.touches[0].pageY,c.touches[0].target.offsetTop):h.offsetY;i.x=h.originalEvent.targetTouches?h.originalEvent.targetTouches[0].pageX:h.pageX,i.y=h.originalEvent.targetTouches?h.originalEvent.targetTouches[0].pageY:h.pageY,r=i.x,p=i.y;var u=n.parent().data("threshold")?n.parent().data("threshold"):n.data("threshold"),l=void 0!==u&&!1!==u&&parseInt(u)?parseInt(u):a.taphold_threshold;return n.data("hold_timer",window.setTimeout(function(){var u=i.x-r,l=i.y-p;if(h.target==t&&(i.x==r&&i.y==p||u>=-a.tap_pixel_range&&u<=a.tap_pixel_range&&l>=-a.tap_pixel_range&&l<=a.tap_pixel_range)){n.data("tapheld",!0);for(var g=Date.now()-s,d=h.originalEvent.targetTouches?h.originalEvent.targetTouches:[h],f=[],v=n.get(0)!==window&&n.get(0)!==document?n.offset():{left:0,top:0},_=0;_<d.length;_++){var m={position:{x:a.touch_capable?c.changedTouches[_].pageX:h.pageX,y:a.touch_capable?c.changedTouches[_].pageY:h.pageY},offset:{x:a.touch_capable?Math.round(c.changedTouches[_].pageX-v.left):Math.round(h.pageX-v.left),y:a.touch_capable?Math.round(c.changedTouches[_].pageY-v.top):Math.round(h.pageY-v.top)},time:Date.now(),target:h.target,duration:g};f.push(m)}var T=2==d.length?"taphold2":"taphold";n.data("callee1",e),w(o,T,h,f)}},l)),!0}).on(a.endevent,function e(){n.data("callee2",e),n.data("tapheld",!1),window.clearTimeout(n.data("hold_timer"))}).on(a.moveevent,function e(t){n.data("callee3",e),r=t.originalEvent.targetTouches?t.originalEvent.targetTouches[0].pageX:t.pageX,p=t.originalEvent.targetTouches?t.originalEvent.targetTouches[0].pageY:t.pageY})},remove:function(){e(this).off(a.startevent,e(this).data.callee1).off(a.endevent,e(this).data.callee2).off(a.moveevent,e(this).data.callee3)}},e.event.special.doubletap={setup:function(){var t,o,n=this,i=e(n),r=null,p=!1;i.on(a.startevent,function t(n){if(n.which&&1!==n.which)return!1;if(i.data("doubletapped",!1),n.target,i.data("callee1",t),o=n.originalEvent,!r){var p=i.get(0)!==window&&i.get(0)!==document?i.offset():{left:0,top:0};r={position:{x:a.touch_capable?o.touches[0].pageX:n.pageX,y:a.touch_capable?o.touches[0].pageY:n.pageY},offset:{x:a.touch_capable?Math.round(o.changedTouches[0].pageX-p.left):Math.round(n.pageX-p.left),y:a.touch_capable?Math.round(o.changedTouches[0].pageY-p.top):Math.round(n.pageY-p.top)},time:Date.now(),target:n.target,element:n.originalEvent.srcElement,index:e(n.target).index()}}return!0}).on(a.endevent,function h(c){var s=Date.now(),u=s-(i.data("lastTouch")||s+1);if(window.clearTimeout(t),i.data("callee2",h),u<a.doubletap_int&&e(c.target).index()==r.index&&u>100){i.data("doubletapped",!0),window.clearTimeout(a.tap_timer);var l=i.get(0)!==window&&i.get(0)!==document?i.offset():{left:0,top:0},g={position:{x:a.touch_capable?c.originalEvent.changedTouches[0].pageX:c.pageX,y:a.touch_capable?c.originalEvent.changedTouches[0].pageY:c.pageY},offset:{x:a.touch_capable?Math.round(o.changedTouches[0].pageX-l.left):Math.round(c.pageX-l.left),y:a.touch_capable?Math.round(o.changedTouches[0].pageY-l.top):Math.round(c.pageY-l.top)},time:Date.now(),target:c.target,element:c.originalEvent.srcElement,index:e(c.target).index()},d={firstTap:r,secondTap:g,interval:g.time-r.time};p||(w(n,"doubletap",c,d),r=null),p=!0,window.setTimeout(function(){p=!1},a.doubletap_int)}else i.data("lastTouch",s),t=window.setTimeout(function(){r=null,window.clearTimeout(t)},a.doubletap_int,[c]);i.data("lastTouch",s)})},remove:function(){e(this).off(a.startevent,e(this).data.callee1).off(a.endevent,e(this).data.callee2)}},e.event.special.singletap={setup:function(){var t=this,o=e(t),n=null,i=null,r={x:0,y:0};o.on(a.startevent,function e(t){return(!t.which||1===t.which)&&(i=Date.now(),n=t.target,o.data("callee1",e),r.x=t.originalEvent.targetTouches?t.originalEvent.targetTouches[0].pageX:t.pageX,r.y=t.originalEvent.targetTouches?t.originalEvent.targetTouches[0].pageY:t.pageY,!0)}).on(a.endevent,function e(p){if(o.data("callee2",e),p.target==n){var h=p.originalEvent.changedTouches?p.originalEvent.changedTouches[0].pageX:p.pageX,c=p.originalEvent.changedTouches?p.originalEvent.changedTouches[0].pageY:p.pageY;a.tap_timer=window.setTimeout(function(){var e=r.x-h,n=r.y-c;if(!o.data("doubletapped")&&!o.data("tapheld")&&(r.x==h&&r.y==c||e>=-a.tap_pixel_range&&e<=a.tap_pixel_range&&n>=-a.tap_pixel_range&&n<=a.tap_pixel_range)){var s=o.get(0)!==window&&o.get(0)!==document?o.offset():{left:0,top:0},u=p.originalEvent,l={position:{x:a.touch_capable?u.changedTouches[0].pageX:p.pageX,y:a.touch_capable?u.changedTouches[0].pageY:p.pageY},offset:{x:a.touch_capable?Math.round(u.changedTouches[0].pageX-s.left):Math.round(p.pageX-s.left),y:a.touch_capable?Math.round(u.changedTouches[0].pageY-s.top):Math.round(p.pageY-s.top)},time:Date.now(),target:p.target};l.time-i<a.taphold_threshold&&w(t,"singletap",p,l)}},a.doubletap_int)}})},remove:function(){e(this).off(a.startevent,e(this).data.callee1).off(a.endevent,e(this).data.callee2)}},e.event.special.tap={setup:function(){var t,o,n=this,i=e(n),r=!1,p=null,h={x:0,y:0};i.on(a.startevent,function e(a){return i.data("callee1",e),(!a.which||1===a.which)&&(r=!0,h.x=a.originalEvent.targetTouches?a.originalEvent.targetTouches[0].pageX:a.pageX,h.y=a.originalEvent.targetTouches?a.originalEvent.targetTouches[0].pageY:a.pageY,t=Date.now(),p=a.target,o=a.originalEvent.targetTouches?a.originalEvent.targetTouches:[a],!0)}).on(a.endevent,function e(c){i.data("callee2",e);var s=c.originalEvent.targetTouches?c.originalEvent.changedTouches[0].pageX:c.pageX,u=c.originalEvent.targetTouches?c.originalEvent.changedTouches[0].pageY:c.pageY,l=h.x-s,g=h.y-u;if(p==c.target&&r&&Date.now()-t<a.taphold_threshold&&(h.x==s&&h.y==u||l>=-a.tap_pixel_range&&l<=a.tap_pixel_range&&g>=-a.tap_pixel_range&&g<=a.tap_pixel_range)){for(var d=i.get(0)!==window&&i.get(0)!==document?i.offset():{left:0,top:0},f=c.originalEvent,v=[],_=0;_<o.length;_++){var m={position:{x:a.touch_capable?f.changedTouches[_].pageX:c.pageX,y:a.touch_capable?f.changedTouches[_].pageY:c.pageY},offset:{x:a.touch_capable?Math.round(f.changedTouches[_].pageX-d.left):Math.round(c.pageX-d.left),y:a.touch_capable?Math.round(f.changedTouches[_].pageY-d.top):Math.round(c.pageY-d.top)},time:Date.now(),target:c.target};v.push(m)}var T=2==o.length?"tap2":"tap";w(n,T,c,v)}})},remove:function(){e(this).off(a.startevent,e(this).data.callee1).off(a.endevent,e(this).data.callee2)}},e.event.special.swipe={setup:function(){var t,o=e(this),n=!1,i=!1,r={x:0,y:0},p={x:0,y:0};o.on(a.startevent,function i(h){(o=e(h.currentTarget)).data("callee1",i),r.x=h.originalEvent.targetTouches?h.originalEvent.targetTouches[0].pageX:h.pageX,r.y=h.originalEvent.targetTouches?h.originalEvent.targetTouches[0].pageY:h.pageY,p.x=r.x,p.y=r.y,n=!0;var c=o.get(0)!==window&&o.get(0)!==document?o.offset():{left:0,top:0},s=h.originalEvent;t={position:{x:a.touch_capable?s.touches[0].pageX:h.pageX,y:a.touch_capable?s.touches[0].pageY:h.pageY},offset:{x:a.touch_capable?Math.round(s.changedTouches[0].pageX-c.left):Math.round(h.pageX-c.left),y:a.touch_capable?Math.round(s.changedTouches[0].pageY-c.top):Math.round(h.pageY-c.top)},time:Date.now(),target:h.target}}),o.on(a.moveevent,function h(c){var s;(o=e(c.currentTarget)).data("callee2",h),p.x=c.originalEvent.targetTouches?c.originalEvent.targetTouches[0].pageX:c.pageX,p.y=c.originalEvent.targetTouches?c.originalEvent.targetTouches[0].pageY:c.pageY;var u=o.parent().data("xthreshold")?o.parent().data("xthreshold"):o.data("xthreshold"),l=o.parent().data("ythreshold")?o.parent().data("ythreshold"):o.data("ythreshold"),g=void 0!==u&&!1!==u&&parseInt(u)?parseInt(u):a.swipe_h_threshold,d=void 0!==l&&!1!==l&&parseInt(l)?parseInt(l):a.swipe_v_threshold;if(Math.abs(p.x-r.x)>Math.abs(p.y-r.y)?(r.x<p.x&&p.x-r.x>g&&(s="swiperight"),r.x>p.x&&r.x-p.x>g&&(s="swipeleft")):(r.y>p.y&&r.y-p.y>d&&(s="swipeup"),r.y<p.y&&p.y-r.y>d&&(s="swipedown")),null!=s&&n){r.x=0,r.y=0,p.x=0,p.y=0,n=!1;var f=o.get(0)!==window&&o.get(0)!==document?o.offset():{left:0,top:0},v=c.originalEvent,w={position:{x:a.touch_capable?v.touches[0].pageX:c.pageX,y:a.touch_capable?v.touches[0].pageY:c.pageY},offset:{x:a.touch_capable?Math.round(v.changedTouches[0].pageX-f.left):Math.round(c.pageX-f.left),y:a.touch_capable?Math.round(v.changedTouches[0].pageY-f.top):Math.round(c.pageY-f.top)},time:Date.now(),target:c.target},_=Math.abs(t.position.x-w.position.x),m=Math.abs(t.position.y-w.position.y),T={startEvnt:t,endEvnt:w,direction:s.replace("swipe",""),xAmount:_,yAmount:m,duration:w.time-t.time};i=!0,o.trigger("swipe",T).trigger(s,T)}}),o.on(a.endevent,function r(p){var h="";if((o=e(p.currentTarget)).data("callee3",r),i){var c=o.data("xthreshold"),s=o.data("ythreshold"),u=void 0!==c&&!1!==c&&parseInt(c)?parseInt(c):a.swipe_h_threshold,l=void 0!==s&&!1!==s&&parseInt(s)?parseInt(s):a.swipe_v_threshold,g=o.get(0)!==window&&o.get(0)!==document?o.offset():{left:0,top:0},d=p.originalEvent,f={position:{x:a.touch_capable?d.changedTouches[0].pageX:p.pageX,y:a.touch_capable?d.changedTouches[0].pageY:p.pageY},offset:{x:a.touch_capable?Math.round(d.changedTouches[0].pageX-g.left):Math.round(p.pageX-g.left),y:a.touch_capable?Math.round(d.changedTouches[0].pageY-g.top):Math.round(p.pageY-g.top)},time:Date.now(),target:p.target},v=Math.abs(t.position.x-f.position.x),w=Math.abs(t.position.y-f.position.y);v>w?(t.position.x<f.position.x&&f.position.x-t.position.x>u&&(h="swiperight"),t.position.x>f.position.x&&t.position.x-f.position.x>u&&(h="swipeleft")):(t.position.y>f.position.y&&t.position.y-f.position.y>l&&(h="swipeup"),t.position.y<f.position.y&&f.position.y-t.position.y>l&&(h="swipedown"));var _={startEvnt:t,endEvnt:f,direction:h.replace("swipe",""),xAmount:v,yAmount:w,duration:f.time-t.time};o.trigger("swipeend",_)}n=!1,i=!1})},remove:function(){e(this).off(a.startevent,e(this).data.callee1).off(a.moveevent,e(this).data.callee2).off(a.endevent,e(this).data.callee3)}},e.event.special.scrollstart={setup:function(){var t,o,n=this,i=e(n);function r(e,a){w(n,(t=a)?"scrollstart":"scrollend",e)}i.on(a.scrollevent,function e(a){i.data("callee",e),t||r(a,!0),clearTimeout(o),o=setTimeout(function(){r(a,!1)},50)})},remove:function(){e(this).off(a.scrollevent,e(this).data.callee)}};var o,n,i,r,p=e(window),h={0:!0,180:!0};if(a.orientation_support){var c=window.innerWidth||p.width(),s=window.innerHeight||p.height();i=c>s&&c-s>50,r=h[window.orientation],(i&&r||!i&&!r)&&(h={"-90":!0,90:!0})}function u(){var e=o();e!==n&&(n=e,p.trigger("orientationchange"))}e.event.special.orientationchange={setup:function(){return!a.orientation_support&&(n=o(),p.on("throttledresize",u),!0)},teardown:function(){return!a.orientation_support&&(p.off("throttledresize",u),!0)},add:function(e){var t=e.handler;e.handler=function(e){return e.orientation=o(),t.apply(this,arguments)}}},e.event.special.orientationchange.orientation=o=function(){var e=document.documentElement;return(a.orientation_support?h[window.orientation]:e&&e.clientWidth/e.clientHeight<1.1)?"portrait":"landscape"},e.event.special.throttledresize={setup:function(){e(this).on("resize",f)},teardown:function(){e(this).off("resize",f)}};var l,g,d,f=function(){g=Date.now(),(d=g-v)>=250?(v=g,e(this).trigger("throttledresize")):(l&&window.clearTimeout(l),l=window.setTimeout(u,250-d))},v=0;function w(t,a,o,n){var i=o.type;o.type=a,e.event.dispatch.call(t,o,n),o.type=i}e.each({scrollend:"scrollstart",swipeup:"swipe",swiperight:"swipe",swipedown:"swipe",swipeleft:"swipe",swipeend:"swipe",tap2:"tap",taphold2:"taphold"},function(t,a){e.event.special[t]={setup:function(){e(this).on(a,e.noop)}}})}(jQuery);